/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

//an import statement means I can refer to a class as if I specified the
//whole package
import javax.swing.JButton;
import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * A simple push button.  It is a subclass of the Swing JButton class.
 * Use it when you want to do something with the press of a button (haha!).
 *
 * @see NGP.Components.RadioButton
 * @see NGP.Components.ToggleButton
 * @see NGP.Components.CheckBox
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JButton.html">javax.swing.JButton</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>) though
 * Jon Moter wrote most of this I think.
 */

public class PushButton extends JButton implements NGP.Component {

  /**
   * Create the push button.
   *
   * @param container the graphical container for the button
   * @param name the string that should appear on the button
   */
  public PushButton(NGP.Container container, String name) {
    super(name);

    this.addActionListener(new ButtonListener());

    container.add(this);
    this.disableSpace();
  }

  /**
   * Set the preferred dimensions of this Component.
   *
   * @param d the <code>Dimension</code> for this <code>Component</code>.
   * @see #getDimension() getDimension
   */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
   * Get the preferred dimensions of this Component.
   *
   * @return the preferred <code>Dimension</code> of this
   * <code>Component</code>.
   * @see #setDimension(java.awt.Dimension) setDimension
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }

  /**
   * Disable the Spacebar from activating this component.
   */
  public void disableSpace() {
    this.unregisterKeyboardAction(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_SPACE, 0));
  }

  /**
   * Called when the button is pressed and released (meaning that it is not
   * called if the user clicks but moves off the button before releasing).
   * Override to do something useful.
   */
  public void release() { }


  /**
   * This inner-class is a listener for the push button.  It will detect when
   * the user clicks on and releases over the push button and then call the
   * {@link release() release} method of the button.
   */
  private class ButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      release();
    }
  }
}
