/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

//an import statement means I can refer to a class as if I specified the
//whole package
import javax.swing.JToggleButton;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/**
 * A simple toggle button.  This class models a toggle button and is a
 * subclass of the Swing JToggleButton component.  Use it when you want to
 * select individual options that are not exclusive of each other.  Very
 * similar to the check box (but this looks like a button, not a box).
 *
 * @see NGP.Components.RadioButton
 * @see NGP.Components.CheckBox
 * @see NGP.Components.PushButton
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JToggleButton.html">javax.swing.JToggleButton</a>
 *
 * @author Matt Chotin(<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class ToggleButton extends JToggleButton implements NGP.Component {

  /**
   * Construct an unselected toggle button.
   *
   * @param container the graphical container for the toggle button
   * @param name the String that will be displayed next to the button
   */
  public ToggleButton(NGP.Container container, String name) {
    this(container, name, false);
  }

  //Added By Brent Shields 6-9-99

  /**
    * Construct an unselected toggle button with an icon instead of a string
    *
    * @param container the graphical container for the toggle button
    * @param icon the icon that will be displayed on the button
    */

  public ToggleButton(NGP.Container container, javax.swing.Icon icon) {
    super(icon);
    
    this.addItemListener(new ToggleButtonListener());
    
    container.add(this);
  }
     

  /**
   * Construct a toggle button and leave it selected or unselected according
   * to the boolean.
   *
   * @param container the graphical container for the toggle button
   * @param name the String that will be displayed next to the button
   * @param selected Use <code>true</code> to select the button and
   * <code>false</code> to leave it unselected.
   */
  public ToggleButton(NGP.Container container, String name,
		      boolean selected) {
    super(name, selected);

    this.addItemListener(new ToggleButtonListener());

    container.add(this);
  }

  /**
   * Set the preferred dimensions of this Component.
   *
   * @param d the <code>Dimension</code> for this <code>Component</code>.
   * @see #getDimension() getDimension
   */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
   * Get the preferred dimensions of this Component.
   *
   * @return the preferred <code>Dimension</code> of this
   * <code>Component</code>.
   * @see #setDimension(java.awt.Dimension) setDimension
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }

  /**
   * Disable the Spacebar from activating this component.
   */
  public void disableSpace() {
    this.unregisterKeyboardAction(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_SPACE, 0));
  }
  
  /**
   * Called when the button is selected.
   * Must override to do something useful.
   */
  public void select() { }

  /**
   * Called when the button is deselected.
   * Must override to do something useful (though not overriding means
   * that nothing will happen when deselected which is often ok).
   */
  public void deselect() { }


  /**
   * This inner-class is a listener for the toggle button.  It will detect when
   * the button is selected/deselected and call the appropriate method of
   * the toggle button.
   */
  private class ToggleButtonListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
	select();
      else if (e.getStateChange() == ItemEvent.DESELECTED)
	deselect();
    }
  }

}
