/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Indicates the basic methods that all graphical objects should implement.
 * All <code>Graphic</code>s have the ability to react when clicked on with
 * the mouse.  In addition they know how to paint themselves on the screen,
 * hide themselves, show themselves, change their
 * {@link NGP.Containers.DrawingPanel DrawingPanel}, rotate, and determine
 * if another <code>Graphic</code> intersects with them.
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Graphic extends Reactor, Rotatable {

  /**
   * Normal users need not call this method!
   * <p>
   * Using the passed in <code>Graphics2D</code> paint this
   * <code>Graphic</code>.
   *
   * @param g the <code>Graphics2D</code> to use when painting
   */
  public void paint(java.awt.Graphics2D g);

  /**
   * Set the <code>Graphic</code> so it does not paint.
   */
  public void hide();

  /**
   * Set the <code>Graphic</code> so it paints.
   */
  public void show();

  /**
   * Set the <code>DrawingPanel</code> where this <code>Graphic</code> should
   * be drawn.
   *
   * @param dp the <code>DrawingPanel</code> to use
   * @see #getDrawingPanel() getDrawingPanel
   */
  public void setDrawingPanel(NGP.Containers.DrawingPanel dp);

  /**
   * Get the <code>DrawingPanel</code> where this <code>Graphic</code> is
   * being drawn.
   *
   * @return this <code>Graphic</code>'s <code>DrawingPanel</code>
   * @see #setDrawingPanel(NGP.Containers.DrawingPanel) setDrawingPanel
   */
  public NGP.Containers.DrawingPanel getDrawingPanel();

  /**
   * Determine whether this <code>Graphic</code>'s bounding rectangle
   * contains the passed in <code>Point</code>.  One use of his method
   * is to determine if a <code>Graphic</code> should react.
   *
   * @param p the Point to check for containment
   * @return <code>true</code> if the Point is contained,
   * <code>false</code> otherwise
   */
  public boolean contains(java.awt.Point p);

  /**
   * Determine whether another <code>Graphic</code>'s bounding rectangle
   * intersects with this <code>Graphic</code>'s bounding rectangle
   *
   * @return <code>true</code> if it does intersect, <code>false</code>
   * if not
   * @see #getBounds getBounds
   */
  public boolean intersects(Graphic g);

  /**
   * Return a copy of this <code>Graphic</code>'s  bounding rectangle.
   * Every Graphic uses has a bounding rectangle to help define its space.
   *
   * @return the java.awt.Rectangle which defines the bounds
   */
  public java.awt.Rectangle getBounds();

  /**
   * Return a Point that represents the center of the Graphic.
   * It's really done by getting the bounds and getting the center of that.
   *
   * @return the java.awt.Point that represents the center
   */
  public java.awt.Point getCenterLocation();

}

