/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Graphics;

/**
 * Used for defining the all of the geometric shapes except for a Line.
 * Added capabilities are the Dimension and Location.
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public abstract class RectangularShape extends Shape implements NGP.Locatable,
  NGP.Sizeable {

  /** Our size */
  private java.awt.Dimension _dimension;
  /** Our location */
  private java.awt.Point _point;
  /** Should our position wrap around the container? */
  private boolean _wrapped = false;

  /**
   * Create a RectangularShape in the specified DrawingPanel
   *
   * @param dp the DrawingPanel for this Shape
   */
  public RectangularShape(NGP.Containers.DrawingPanel dp, java.awt.Shape s) {
    super(dp, s);
		_point = new java.awt.Point();
		_dimension = new java.awt.Dimension();
    this.setDimension(new java.awt.Dimension(5,5));
    this.setLocation(new java.awt.Point(0,0));
  }

  /**
   * Get the dimensions of this RectangularShape.
   *
   * @return the <code>Dimension</code> of this RectangularShape
   */
  public java.awt.Dimension getDimension() {
    return _dimension;
  }

  /**
   * Set the dimensions of this RectangularShape.
   *
   * @param d the new <code>Dimension</code> of this RectangularShape
   */
  public void setDimension(java.awt.Dimension d) {
		java.awt.Rectangle oldBounds = this.getBounds();
    _dimension = d;
    ((java.awt.geom.RectangularShape)_awtShape).setFrame(_point, d);
		_dpanel.repaint(this.getBounds().union(oldBounds));
  }

  /**
   * Get the location of this RectangularShape
   *
   * @return the <code>Point</code> of this RectangularShape
   */
  public java.awt.Point getLocation() {
    return _point;
  }

  /**
   * Set the location of this RectangularShape
   *
   * @param p the new <code>Point</code> for this RectangularShape
   */
  public void setLocation(java.awt.Point p) {
		java.awt.Rectangle oldBounds = this.getBounds();
    _point = p;
    if (_wrapped) {
      java.awt.Dimension panelSize = _dpanel.getDimension();
      int x = _point.x%panelSize.width;
      int y = _point.y%panelSize.height;
      if (x < 0) x += panelSize.width;
      if (y < 0) y += panelSize.height;
      _point.x = x;
      _point.y = y;
    }
    ((java.awt.geom.RectangularShape)_awtShape).setFrame(_point, _dimension);
    _dpanel.repaint(this.getBounds().union(oldBounds));
  }

  /**
   * Set the location of the RectangularShape so that its center point is
   * at the specified location.
   *
   * @param p the new <code>Point</code> for the center of this
   * RectangularShape
   */
  public void setCenterLocation(java.awt.Point p) {
    this.setLocation(new java.awt.Point(p.x - _dimension.width/2,
					p.y - _dimension.height/2));
  }

  /** Set this shape so that it will always display in its DrawingPanel */
  public void wrap() {
    _wrapped = true;
  }

  /**
   * Set this shape so that it will does not necessarily display in its
   * DrawingPanel
   */
  public void unwrap() {
    _wrapped = false;
  }

}

