#include "MPUtility.h"
#include "Solution.cpp"
#include "Graph.h"
#include "Revenue.cpp"
#include "Objects.h"
#include "Simulator.cpp"
#include "Traversals.cpp"
#include <fstream>
#include <unordered_map>
#include <vector>
#include <string>
#include <utility>

using namespace std;

class Driver;

int main(int argc, char **argv)
{

    if (argc < 2)
    {
        cout << "Please put the filename as an argument." << endl;
    }

    MPUtility utility;

    int problem = 1; // change this to the problem # you are working on

    string inputFile = argv[1];

    Graph input = utility.readFile(inputFile);

    pair<vector<Client>, vector<int>> b_c = utility.readInfo(inputFile + "-info", problem);
    int band_incr = utility.readIncrease(inputFile + "-info", problem);
    unordered_map<string, pair<float, int>> fines = utility.readFines(inputFile + "-info", problem);

    Solution s(problem, input, b_c.first, b_c.second, fines, band_incr);
    Solution_Object studentSolution = s.outputPaths();
    cout << "Your solution " << endl;
    cout << "==========================================" << endl;
    if (studentSolution.paths.empty())
    {
        cout << "Your paths are empty!!!" << endl;
        return 0;
    }

    if (problem == 1 || problem == 2)
    {
        studentSolution.bandwidths = b_c.second;
    }

    if (problem >= 3 && problem <= 5) {
        if (studentSolution.bandwidths.empty()) {
            studentSolution.bandwidths = b_c.second;
        }
    }

    unordered_map<int, int> delays = Simulator(input, studentSolution, b_c.first);

    int rev = 0;

    switch (problem)
    {
    case 1:
    case 2:
    {
        rev = pen_0(input, b_c.first, delays, false, false);
        break;
    }
    case 3:
    {
        rev = pen_0(input, b_c.first, delays, false, false) - pen_1(input, b_c.first, delays, fines) - bandwidth_increase(b_c.second, studentSolution.bandwidths, band_incr);
        break;
    }
    case 4:
    {
        rev = pen_0(input, b_c.first, delays, true, false) - pen_1(input, b_c.first, delays, fines) - bandwidth_increase(b_c.second, studentSolution.bandwidths, band_incr);
        break;
    }

    case 5:
    {
        rev = pen_0(input, b_c.first, delays, false, true) - bandwidth_increase(b_c.second, studentSolution.bandwidths, band_incr);
        break;
    }
    }
    cout << "Revenue: " << rev << endl;
    return 0;
}
