//
// Created by Sanchit Batra on 8/14/19.
// Updated by Veronica Vitale on 1 September 2019
//

#include <algorithm>
#include <list>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <fstream>
#include <iostream>

#include "Simulator.h"
#include "Objects.h"
#include "Traversals.h"

using namespace std;

void printVec(vector<Client> *clients, unordered_map<int, int> &delays)
{
  for (auto it = clients->begin(); it != clients->end(); ++it)
  {
    auto c = *it;
    cout << "For client ID(" << c.id << "), alpha=" << c.alpha << ", priority: " << c.priority
         << ", delays: " << delays[c.id] << "\n";
  }
}
//runs the simulation
unordered_map<int, int> Simulator(Graph &g, Solution_Object &sol, const vector<Client> &clients_vec)
{

  // for students who have a "better" path than the shortest path
  unordered_map<int, int> shortestDistances = bfs(g, clients_vec);

  vector<Client> *clients = new vector<Client>();
  // copy over the clients first
  for (const Client &c : clients_vec)
  {
    clients->push_back(Client(c.id, c.alpha, c.beta, c.payment, c.is_rural, c.is_fcc, 0));
  }

  // sort clients based on priorities
  if (!sol.priorities.empty())
  {
    for (auto it = clients->begin(); it != clients->end(); ++it)
    {
      Client &c = *it;
      c.priority = sol.priorities[c.id];
    }
    sort(clients->begin(), clients->end(), comparePrio);
  }
  //index of path for each client ; where the packet is
  unordered_map<int, int> locations;
  //list to be used to make iterating through clients easier
  list<Client> list_clients;
  //map of calculated delays
  unordered_map<int, int> calc_delays;
  // packet delays for clients
  unordered_map<int, int> packet_delay;
  // keeps track of nodes that participated in forwarding in one iteration
  unordered_set<int> active;

  for (auto it = clients->begin(); it != clients->end(); ++it)
  {
    const Client &c = *it;
    //  cout << "client: " << c.id << endl;
    packet_delay[c.id] = 0;
    // if the client doesnt have a path or doesnt have the correct start node we rage
    if (sol.paths.at(c.id).empty())
    {

      calc_delays[c.id] = -1;
    }
    else if (sol.paths.at(c.id).at(0) != g.contentProvider)
    {

      calc_delays[c.id] = -1;
    }
    else
    {
      // set up for locations and list
      locations[c.id] = 0;
      list_clients.push_back(Client(c.id, c.alpha, c.beta, c.payment, c.is_rural, c.is_fcc, c.priority));
    }
  }
  vector<int> current_bandwidths(sol.bandwidths.begin(), sol.bandwidths.end());

  while (!list_clients.empty())
  {

    // current is the client whose packet is being processed
    auto current = list_clients.begin();

    while (current != list_clients.end())
    {

      // sol has paths, priorities and bandwidths
      //    paths is a map from client id to its path
      // clients has list of Client objects
      if (sol.paths[current->id].size() == 0)
      {

        calc_delays[current->id] = -1;
        current=list_clients.erase(current);
        continue;
      }

      else if (sol.paths[current->id][0] != g.contentProvider)
      {
        calc_delays[current->id] = -1;
        current=list_clients.erase(current);
        continue;
      }

      int current_location = locations[current->id];
      // The node the packet is currently at, different from the "current" node
      // which is the one whose packet we are considering
      int current_node_id = sol.paths[current->id][current_location];

      if (current_location == (sol.paths.at(current->id).size() - 1))
      {
        if (current_node_id == current->id && current_location >= shortestDistances[current->id])
        {
          calc_delays[current->id] = packet_delay[current->id];
        }
        else
        {
          calc_delays[current->id] = -1;
        }
        current=list_clients.erase(current);
        continue;
      }
      packet_delay[current->id]++;

      if (current_bandwidths[current_node_id] != 0)
      {
        active.insert(current_node_id);
        current_bandwidths[current_node_id]--;
        locations[current->id]++;
        if (!(isValid(g, current_node_id, sol.paths[current->id][locations[current->id]])))
        {

          list_clients.erase(current);
          calc_delays[current->id] = -1;
        }
      }
      current++;
    }
    for (int router : active)
    {
      current_bandwidths[router] = sol.bandwidths[router];
    }
    active.clear();
  }
  return calc_delays;
}

// comparator for sorting clients based on priorities in descending order
inline bool comparePrio(const Client &a, const Client &b)
{
  if (a.priority == b.priority)
  {
    return a.id < b.id;
  }
  return a.priority > b.priority;
}
//determines if a location is valid
inline bool isValid(const Graph &g, const int a, const int b)
{
  return g.graph_set.at(a).find(b) != g.graph_set.at(a).end();
}
